<?php
session_start();
include 'includes/db.php';
include 'includes/functions.php';
requireLogin();
$uid = $_SESSION['user_id'];
$msg = ''; $err = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action = $_POST['action'] ?? '';
    if ($action == 'add') {
        $title = sanitize($conn, $_POST['title'] ?? '');
        $desc  = sanitize($conn, $_POST['description'] ?? '');
        $date  = sanitize($conn, $_POST['remind_date'] ?? '');
        if (!$title || !$date) { $err = 'Title and date are required.'; }
        else {
            mysqli_query($conn, "INSERT INTO reminders (user_id, title, description, remind_date)
                                 VALUES ($uid, '$title', '$desc', '$date')");
            $msg = 'Reminder added! ✅';
        }
    }
    if ($action == 'done') {
        $rid = (int)$_POST['rid'];
        mysqli_query($conn, "UPDATE reminders SET is_done=1 WHERE id=$rid AND user_id=$uid");
        $msg = 'Reminder marked as done!';
    }
}
if (isset($_GET['delete'])) {
    $did = (int)$_GET['delete'];
    mysqli_query($conn, "DELETE FROM reminders WHERE id=$did AND user_id=$uid");
    header("Location: " . BASE_PATH . "/reminders.php?deleted=1");
    exit();
}
if (isset($_GET['deleted'])) $msg = 'Reminder deleted.';

$upcoming = mysqli_query($conn, "SELECT * FROM reminders WHERE user_id=$uid AND is_done=0 ORDER BY remind_date ASC");
$done_rem = mysqli_query($conn, "SELECT * FROM reminders WHERE user_id=$uid AND is_done=1 ORDER BY remind_date DESC LIMIT 10");

$pageTitle = 'Reminders';
include 'includes/header.php';
?>

<div class="container">
    <div class="page-header">
        <h1><span class="emoji">🔔</span> Reminders</h1>
        <p>Stay on top of your study schedule with custom reminders.</p>
    </div>

    <?php if ($msg): ?><div class="alert alert-success">✅ <?= htmlspecialchars($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert alert-error">⚠️ <?= htmlspecialchars($err) ?></div><?php endif; ?>

    <div class="grid-main-side">
        <div>
            <!-- Upcoming -->
            <div class="card" style="margin-bottom:1.5rem">
                <div class="card-title">⏰ Upcoming Reminders</div>
                <?php if (mysqli_num_rows($upcoming) == 0): ?>
                    <div class="empty-state"><div class="empty-icon">🔕</div><h3>No upcoming reminders</h3><p>Add one using the form!</p></div>
                <?php else: ?>
                <?php while ($r = mysqli_fetch_assoc($upcoming)):
                    $isPast = strtotime($r['remind_date']) < time();
                ?>
                <div style="display:flex;align-items:flex-start;gap:1rem;padding:1rem 0;border-bottom:1px solid var(--border)">
                    <div style="flex:1">
                        <div style="font-weight:600;font-size:0.95rem"><?= htmlspecialchars($r['title']) ?></div>
                        <?php if ($r['description']): ?>
                        <div style="font-size:0.82rem;color:var(--text-muted);margin-top:0.2rem"><?= htmlspecialchars($r['description']) ?></div>
                        <?php endif; ?>
                        <div style="font-size:0.8rem;margin-top:0.4rem;color:<?= $isPast ? 'var(--danger)' : 'var(--warning)' ?>">
                            📅 <?= date('D, M d Y g:i A', strtotime($r['remind_date'])) ?>
                            <?= $isPast ? ' <span style="color:var(--danger)">(Overdue)</span>' : '' ?>
                        </div>
                    </div>
                    <div style="display:flex;gap:0.5rem">
                        <form method="POST" style="display:inline">
                            <input type="hidden" name="action" value="done">
                            <input type="hidden" name="rid" value="<?= $r['id'] ?>">
                            <button class="btn btn-success btn-sm">✓</button>
                        </form>
                        <a href="?delete=<?= $r['id'] ?>" class="btn btn-danger btn-sm" data-confirm="Delete reminder?">🗑️</a>
                    </div>
                </div>
                <?php endwhile; ?>
                <?php endif; ?>
            </div>

            <!-- Done -->
            <?php if (mysqli_num_rows($done_rem) > 0): ?>
            <div class="card">
                <div class="card-title">✅ Completed Reminders</div>
                <?php while ($r = mysqli_fetch_assoc($done_rem)): ?>
                <div style="padding:0.6rem 0;border-bottom:1px solid var(--border);opacity:0.6">
                    <div style="font-size:0.88rem;text-decoration:line-through"><?= htmlspecialchars($r['title']) ?></div>
                    <div style="font-size:0.75rem;color:var(--text-muted)"><?= date('M d Y', strtotime($r['remind_date'])) ?></div>
                </div>
                <?php endwhile; ?>
            </div>
            <?php endif; ?>
        </div>

        <!-- ADD FORM -->
        <div>
            <div class="card">
                <div class="card-title">➕ Add Reminder</div>
                <form method="POST">
                    <input type="hidden" name="action" value="add">
                    <div class="form-group">
                        <label class="form-label">Title *</label>
                        <input type="text" name="title" class="form-control" placeholder="e.g. Revision – Integration" required>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Description</label>
                        <textarea name="description" class="form-control" placeholder="Optional details..."></textarea>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Remind Date & Time *</label>
                        <input type="datetime-local" name="remind_date" class="form-control" required>
                    </div>
                    <button type="submit" class="btn btn-primary btn-block">🔔 Add Reminder</button>
                </form>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
