<?php
session_start();
include 'includes/db.php'; // defines BASE_PATH

if (isset($_SESSION['user_id'])) {
    header("Location: " . BASE_PATH . "/dashboard.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>StudyTrack LK - A/L Student Progress Tracker</title>
    <link rel="stylesheet" href="<?= BASE_PATH ?>/assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800;900&display=swap" rel="stylesheet">
    <style>
        .landing-nav{display:flex;align-items:center;justify-content:space-between;padding:1.2rem 3rem;border-bottom:1px solid var(--border);position:sticky;top:0;background:rgba(10,10,15,0.9);backdrop-filter:blur(20px);z-index:100}
        .hero{text-align:center;padding:6rem 2rem 4rem}
        .hero-badge{display:inline-block;background:rgba(108,63,197,0.15);border:1px solid rgba(108,63,197,0.3);border-radius:99px;padding:.4rem 1rem;font-size:.82rem;color:var(--purple-light);margin-bottom:1.5rem}
        .hero h1{font-size:clamp(2.5rem,6vw,4.5rem);font-weight:900;line-height:1.1;letter-spacing:-2px;max-width:800px;margin:0 auto 1.5rem}
        .hero h1 .grad{background:linear-gradient(135deg,var(--purple-light),var(--accent),var(--green));-webkit-background-clip:text;-webkit-text-fill-color:transparent}
        .hero p{font-size:1.15rem;color:var(--text-secondary);max-width:550px;margin:0 auto 2.5rem;line-height:1.7}
        .hero-btns{display:flex;gap:1rem;justify-content:center;flex-wrap:wrap}
        .features{max-width:1100px;margin:4rem auto;padding:0 2rem}
        .features h2{text-align:center;font-size:2rem;font-weight:800;margin-bottom:3rem}
        .features-grid{display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:1.5rem}
        .feature-card{background:var(--bg-card);border:1px solid var(--border);border-radius:var(--radius);padding:1.75rem;transition:all .3s}
        .feature-card:hover{border-color:var(--border-glow);transform:translateY(-4px);box-shadow:var(--shadow-glow)}
        .feature-icon{font-size:2.2rem;margin-bottom:1rem}
        .feature-card h3{font-size:1rem;font-weight:700;margin-bottom:.5rem}
        .feature-card p{font-size:.85rem;color:var(--text-secondary);line-height:1.6}
        .cta-section{text-align:center;padding:5rem 2rem}
        .glow-line{height:1px;background:linear-gradient(90deg,transparent,var(--purple),var(--green),transparent);max-width:600px;margin:4rem auto}
    </style>
</head>
<body>

<nav class="landing-nav">
    <div style="display:flex;align-items:center;gap:.6rem">
        <span style="font-size:1.5rem">📚</span>
        <span style="font-size:1.2rem;font-weight:700">StudyTrack <span style="color:var(--green)">LK</span></span>
    </div>
    <div style="display:flex;gap:1rem">
        <a href="<?= BASE_PATH ?>/login.php"    class="btn btn-outline btn-sm">Login</a>
        <a href="<?= BASE_PATH ?>/register.php" class="btn btn-primary btn-sm">Get Started</a>
    </div>
</nav>

<section class="hero">
    <div class="hero-badge">🇱🇰 Built for Sri Lankan A/L Students</div>
    <h1>Track Your <span class="grad">A/L Journey</span> to Success</h1>
    <p>Monitor your study hours, past papers, goals, and analytics — all in one powerful platform designed for Sri Lankan Advanced Level students.</p>
    <div class="hero-btns">
        <a href="<?= BASE_PATH ?>/register.php" class="btn btn-primary"  style="font-size:1rem;padding:.9rem 2rem">🚀 Start Tracking Free</a>
        <a href="<?= BASE_PATH ?>/login.php"    class="btn btn-outline"  style="font-size:1rem;padding:.9rem 2rem">Sign In</a>
    </div>
</section>

<div class="glow-line"></div>

<section class="features">
    <h2>Everything You Need to <span style="color:var(--green)">Excel</span></h2>
    <div class="features-grid">
        <div class="feature-card"><div class="feature-icon">📊</div><h3>Smart Dashboard</h3><p>Complete overview of study hours, progress, streaks, and performance at a glance.</p></div>
        <div class="feature-card"><div class="feature-icon">⏱️</div><h3>Study Logger</h3><p>Log every study session with subject, hours, and notes. Track weekly and monthly trends.</p></div>
        <div class="feature-card"><div class="feature-icon">📝</div><h3>Past Paper Tracker</h3><p>Record marks for every past paper. Discover weak topics and improve systematically.</p></div>
        <div class="feature-card"><div class="feature-icon">🎯</div><h3>Goal Setting</h3><p>Set target grades per subject. Track your Z-score goal and see if you're on track.</p></div>
        <div class="feature-card"><div class="feature-icon">📈</div><h3>Deep Analytics</h3><p>Beautiful charts showing your improvement over time. Identify strengths and weaknesses.</p></div>
        <div class="feature-card"><div class="feature-icon">🔥</div><h3>Study Streaks</h3><p>Build daily study habits with streak tracking. Earn badges as you reach milestones.</p></div>
        <div class="feature-card"><div class="feature-icon">🤖</div><h3>AI Feedback</h3><p>Personalized study recommendations and grade predictions powered by AI analysis.</p></div>
        <div class="feature-card"><div class="feature-icon">🏛️</div><h3>University Cutoffs</h3><p>Check Z-score cutoffs for top Sri Lankan universities. Know exactly what you need.</p></div>
    </div>
</section>

<div class="glow-line"></div>

<section class="cta-section">
    <h2>Ready to Take <span style="color:var(--purple-light)">Control</span> of Your Studies?</h2>
    <p style="color:var(--text-secondary);margin-bottom:2rem">Join A/L students already tracking their progress with StudyTrack LK.</p>
    <a href="<?= BASE_PATH ?>/register.php" class="btn btn-success" style="font-size:1.05rem;padding:1rem 2.5rem">🎓 Create Free Account</a>
</section>

<footer class="footer">
    <p>📚 StudyTrack LK &copy; <?= date('Y') ?> &mdash; Made with 💜 for A/L Students in Sri Lanka</p>
</footer>
</body>
</html>
