<?php
session_start();
include 'includes/db.php';
include 'includes/functions.php';
requireLogin();
$uid = $_SESSION['user_id'];
$msg = ''; $err = '';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $action  = $_POST['action'] ?? '';
    if ($action == 'add' || $action == 'update') {
        $subject  = sanitize($conn, $_POST['subject'] ?? '');
        $target   = sanitize($conn, $_POST['target_grade'] ?? '');
        $current  = sanitize($conn, $_POST['current_grade'] ?? 'F');
        $notes    = sanitize($conn, $_POST['notes'] ?? '');
        if (!$subject || !$target) { $err = 'Subject and target grade required.'; }
        else {
            $check = mysqli_fetch_assoc(mysqli_query($conn,
                "SELECT id FROM goals WHERE user_id=$uid AND subject='$subject'"));
            if ($check) {
                mysqli_query($conn, "UPDATE goals SET target_grade='$target', current_grade='$current', notes='$notes' WHERE id={$check['id']} AND user_id=$uid");
                $msg = 'Goal updated!';
            } else {
                mysqli_query($conn, "INSERT INTO goals (user_id, subject, target_grade, current_grade, notes)
                                     VALUES ($uid, '$subject', '$target', '$current', '$notes')");
                $msg = 'Goal added!';
            }
        }
    }
    if ($action == 'update_zscore') {
        $zs = (float)$_POST['target_zscore'];
        mysqli_query($conn, "UPDATE users SET target_zscore=$zs WHERE id=$uid");
        $msg = 'Z-Score target updated!';
    }
}

if (isset($_GET['delete'])) {
    $did = (int)$_GET['delete'];
    mysqli_query($conn, "DELETE FROM goals WHERE id=$did AND user_id=$uid");
    header("Location: " . BASE_PATH . "/goals.php?deleted=1");
    exit();
}
if (isset($_GET['deleted'])) $msg = 'Goal removed.';

$user  = getUser($conn, $uid);
$goals = mysqli_query($conn, "SELECT * FROM goals WHERE user_id=$uid ORDER BY subject ASC");
$pageTitle = 'Goals';
include 'includes/header.php';
?>

<div class="container">
    <div class="page-header">
        <h1><span class="emoji">🎯</span> My Goals</h1>
        <p>Set your target grades for each subject and track your current progress.</p>
    </div>

    <?php if ($msg): ?><div class="alert alert-success">✅ <?= htmlspecialchars($msg) ?></div><?php endif; ?>
    <?php if ($err): ?><div class="alert alert-error">⚠️ <?= htmlspecialchars($err) ?></div><?php endif; ?>

    <div class="grid-2" style="margin-bottom:1.5rem">
        <!-- Z-Score Target -->
        <div class="card">
            <div class="card-title">🏆 Z-Score Target</div>
            <form method="POST">
                <input type="hidden" name="action" value="update_zscore">
                <div class="form-group">
                    <label class="form-label">Target Z-Score</label>
                    <input type="number" name="target_zscore" class="form-control" step="0.0001" min="0" max="3" placeholder="e.g. 1.9500" value="<?= $user['target_zscore'] ?>">
                </div>
                <div style="background:rgba(108,63,197,0.1);border:1px solid rgba(108,63,197,0.2);border-radius:8px;padding:1rem;margin-bottom:1rem;font-size:0.83rem;color:var(--text-secondary)">
                    💡 Z-Score ranges from about 0.5 (pass) to 2.5+ (top students). 
                    Check the <a href="<?= BASE_PATH ?>/university.php" style="color:var(--purple-light)">University Cutoffs</a> page for guidance.
                </div>
                <button type="submit" class="btn btn-primary btn-block">💾 Save Z-Score Target</button>
            </form>
        </div>

        <!-- Add Goal -->
        <div class="card">
            <div class="card-title">➕ Add / Update Subject Goal</div>
            <form method="POST">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label class="form-label">Subject *</label>
                    <select name="subject" class="form-control" required>
                        <option value="">Select Subject</option>
                        <?php foreach(['Combined Maths','Physics','Chemistry','Biology','ICT','Economics','Accounting','Business Studies','History','Geography','Art','Sinhala','Tamil','English','Other'] as $s): ?>
                        <option value="<?= $s ?>"><?= $s ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="form-grid">
                    <div class="form-group">
                        <label class="form-label">Current Grade</label>
                        <select name="current_grade" class="form-control">
                            <?php foreach(['F','S','C','B','A'] as $g): ?>
                            <option value="<?= $g ?>"><?= $g ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label class="form-label">Target Grade *</label>
                        <select name="target_grade" class="form-control" required>
                            <?php foreach(['A','B','C','S'] as $g): ?>
                            <option value="<?= $g ?>"><?= $g ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="form-group">
                    <label class="form-label">Notes</label>
                    <textarea name="notes" class="form-control" placeholder="e.g. Focus on integration chapter"></textarea>
                </div>
                <button type="submit" class="btn btn-success btn-block">🎯 Save Goal</button>
            </form>
        </div>
    </div>

    <!-- GOALS LIST -->
    <div class="card">
        <div class="card-title">📋 My Subject Goals</div>
        <?php if (mysqli_num_rows($goals) == 0): ?>
            <div class="empty-state"><div class="empty-icon">🎯</div><h3>No goals set</h3><p>Add your first subject goal above.</p></div>
        <?php else: ?>
        <div style="display:grid;grid-template-columns:repeat(auto-fill,minmax(280px,1fr));gap:1rem">
        <?php
        $gc = ['A'=>'var(--green)','B'=>'var(--purple-light)','C'=>'var(--warning)','S'=>'#f97316','F'=>'var(--danger)'];
        $gp = ['A'=>100,'B'=>80,'C'=>60,'S'=>40,'F'=>20];
        while ($g = mysqli_fetch_assoc($goals)): ?>
        <div class="card" style="padding:1.25rem">
            <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:1rem">
                <div style="font-weight:700;font-size:0.95rem"><?= htmlspecialchars($g['subject']) ?></div>
                <a href="?delete=<?= $g['id'] ?>" class="btn btn-danger btn-sm" data-confirm="Remove this goal?">🗑️</a>
            </div>
            <div style="display:flex;gap:0.5rem;margin-bottom:0.75rem">
                <div style="flex:1;text-align:center;background:var(--bg-secondary);padding:0.6rem;border-radius:8px">
                    <div style="font-size:0.72rem;color:var(--text-muted)">Current</div>
                    <div style="font-size:1.5rem;font-weight:800;color:<?= $gc[$g['current_grade']] ?>"><?= $g['current_grade'] ?></div>
                </div>
                <div style="display:flex;align-items:center;color:var(--text-muted);font-size:1.2rem">→</div>
                <div style="flex:1;text-align:center;background:var(--bg-secondary);padding:0.6rem;border-radius:8px">
                    <div style="font-size:0.72rem;color:var(--text-muted)">Target</div>
                    <div style="font-size:1.5rem;font-weight:800;color:<?= $gc[$g['target_grade']] ?>"><?= $g['target_grade'] ?></div>
                </div>
            </div>
            <div class="progress-bar">
                <div class="progress-fill" data-width="<?= $gp[$g['current_grade']] ?>" style="width:0;background:<?= $gc[$g['current_grade']] ?>"></div>
            </div>
            <?php if ($g['notes']): ?>
            <p style="font-size:0.78rem;color:var(--text-muted);margin-top:0.5rem;font-style:italic"><?= htmlspecialchars($g['notes']) ?></p>
            <?php endif; ?>
        </div>
        <?php endwhile; ?>
        </div>
        <?php endif; ?>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
