<?php
session_start();
include 'includes/db.php';
include 'includes/functions.php';
requireLogin();

$uid         = $_SESSION['user_id'];
$user        = getUser($conn, $uid);
$weekHours   = getWeekHours($conn, $uid);
$totalHours  = getTotalHours($conn, $uid);
$papers      = getPapersCount($conn, $uid);
$streak      = getStreak($conn, $uid);
$avgScore    = getAvgScore($conn, $uid);
$subjectHrs  = getSubjectHours($conn, $uid);
$recentSess  = getRecentSessions($conn, $uid, 5);
$badges_res  = mysqli_query($conn, "SELECT * FROM badges WHERE user_id=$uid ORDER BY earned_at DESC");

// Goals
$goals_res = mysqli_query($conn, "SELECT * FROM goals WHERE user_id=$uid");

// Reminders upcoming
$rem_res = mysqli_query($conn, "SELECT * FROM reminders WHERE user_id=$uid AND is_done=0 AND remind_date >= NOW() ORDER BY remind_date ASC LIMIT 3");

// Chart data
$labels = []; $data = [];
foreach ($subjectHrs as $sh) { $labels[] = $sh['subject']; $data[] = round($sh['total'],1); }

// Monthly trend (last 6 months)
$months = []; $month_data = [];
for ($i = 5; $i >= 0; $i--) {
    $m    = date('Y-m', strtotime("-$i months"));
    $mlbl = date('M Y', strtotime("-$i months"));
    $r    = mysqli_fetch_assoc(mysqli_query($conn,
        "SELECT COALESCE(SUM(hours),0) as h FROM study_sessions
         WHERE user_id=$uid AND DATE_FORMAT(session_date,'%Y-%m')='$m'"));
    $months[]     = $mlbl;
    $month_data[] = round($r['h'], 1);
}

checkAndAwardBadges($conn, $uid);
$pageTitle = 'Dashboard';
include 'includes/header.php';
?>

<div class="container">
    <div class="page-header">
        <h1><span class="emoji">🏠</span> Dashboard</h1>
        <p>Welcome back, <?= htmlspecialchars($user['name']) ?>! Here's your study overview.</p>
    </div>

    <!-- STREAK -->
    <div class="streak-display" style="margin-bottom:1.5rem">
        <div class="streak-fire">🔥</div>
        <div class="streak-info">
            <h3><?= $streak ?> Day<?= $streak != 1 ? 's' : '' ?></h3>
            <p>Current study streak — keep it going!</p>
        </div>
        <div style="margin-left:auto;text-align:right">
            <div style="color:var(--text-muted);font-size:0.78rem">Stream</div>
            <div style="color:var(--purple-light);font-weight:600"><?= $user['stream'] ?></div>
            <?php if ($user['target_zscore'] > 0): ?>
            <div style="color:var(--text-muted);font-size:0.78rem;margin-top:0.25rem">Target Z-Score</div>
            <div style="color:var(--green);font-weight:700"><?= number_format($user['target_zscore'],4) ?></div>
            <?php endif; ?>
        </div>
    </div>

    <!-- STATS -->
    <div class="stats-grid">
        <div class="stat-card purple">
            <div class="stat-icon">⏱️</div>
            <div class="stat-label">This Week</div>
            <div class="stat-value" data-count="<?= $weekHours ?>" data-decimal="1"><?= $weekHours ?></div>
            <div class="stat-sub">Hours studied</div>
        </div>
        <div class="stat-card green">
            <div class="stat-icon">📚</div>
            <div class="stat-label">Total Hours</div>
            <div class="stat-value" data-count="<?= $totalHours ?>" data-decimal="1"><?= $totalHours ?></div>
            <div class="stat-sub">All time</div>
        </div>
        <div class="stat-card blue">
            <div class="stat-icon">📝</div>
            <div class="stat-label">Past Papers</div>
            <div class="stat-value" data-count="<?= $papers ?>"><?= $papers ?></div>
            <div class="stat-sub">Papers completed</div>
        </div>
        <div class="stat-card orange">
            <div class="stat-icon">🎯</div>
            <div class="stat-label">Avg Score</div>
            <div class="stat-value" data-count="<?= $avgScore ?>" data-decimal="1"><?= $avgScore ?></div>
            <div class="stat-sub">% across papers</div>
        </div>
    </div>

    <!-- CHARTS ROW -->
    <div class="grid-2" style="margin-bottom:1.5rem">
        <div class="card">
            <div class="card-title">📊 Study Hours by Subject</div>
            <?php if (empty($subjectHrs)): ?>
                <div class="empty-state"><div class="empty-icon">📖</div><h3>No sessions yet</h3><p>Start logging your study sessions!</p></div>
            <?php else: ?>
            <div class="chart-container"><canvas id="subjectChart" height="220"></canvas></div>
            <?php endif; ?>
        </div>
        <div class="card">
            <div class="card-title">📈 Monthly Study Trend</div>
            <div class="chart-container"><canvas id="monthChart" height="220"></canvas></div>
        </div>
    </div>

    <div class="grid-main-side">
        <!-- RECENT SESSIONS -->
        <div class="card">
            <div class="card-title" style="justify-content:space-between">
                <span>⏱️ Recent Study Sessions</span>
                <a href="<?= BASE_PATH ?>/study-log.php" class="btn btn-outline btn-sm">+ Add Session</a>
            </div>
            <?php if (empty($recentSess)): ?>
                <div class="empty-state"><div class="empty-icon">⏰</div><h3>No sessions logged</h3><p><a href="<?= BASE_PATH ?>/study-log.php" style="color:var(--purple-light)">Log your first session →</a></p></div>
            <?php else: ?>
            <div class="table-wrap">
                <table>
                    <thead><tr><th>Date</th><th>Subject</th><th>Hours</th><th>Notes</th></tr></thead>
                    <tbody>
                    <?php foreach ($recentSess as $s): ?>
                        <tr>
                            <td><?= date('M d', strtotime($s['session_date'])) ?></td>
                            <td><span class="badge badge-purple"><?= htmlspecialchars($s['subject']) ?></span></td>
                            <td style="color:var(--green);font-weight:600"><?= $s['hours'] ?>h</td>
                            <td style="color:var(--text-muted);font-size:0.82rem"><?= htmlspecialchars(substr($s['notes'] ?? '-', 0, 40)) ?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
            <?php endif; ?>
        </div>

        <!-- SIDEBAR -->
        <div style="display:flex;flex-direction:column;gap:1.5rem">
            <!-- GOALS -->
            <div class="card">
                <div class="card-title" style="justify-content:space-between">
                    <span>🎯 My Goals</span>
                    <a href="<?= BASE_PATH ?>/goals.php" class="btn btn-outline btn-sm">Manage</a>
                </div>
                <?php if (mysqli_num_rows($goals_res) == 0): ?>
                    <p style="color:var(--text-muted);font-size:0.85rem;text-align:center;padding:1rem"><a href="<?= BASE_PATH ?>/goals.php" style="color:var(--purple-light)">Set your goals →</a></p>
                <?php else: ?>
                <?php while ($g = mysqli_fetch_assoc($goals_res)):
                    $colors = ['A'=>'var(--green)','B'=>'var(--purple-light)','C'=>'var(--warning)','S'=>'#f97316','F'=>'var(--danger)'];
                    $pct = ['A'=>100,'B'=>80,'C'=>60,'S'=>40,'F'=>20];
                ?>
                <div style="margin-bottom:1rem">
                    <div style="display:flex;justify-content:space-between;font-size:0.85rem;margin-bottom:0.3rem">
                        <span><?= htmlspecialchars($g['subject']) ?></span>
                        <span style="color:<?= $colors[$g['target_grade']] ?>">Target: <?= $g['target_grade'] ?></span>
                    </div>
                    <div class="progress-bar">
                        <div class="progress-fill" data-width="<?= $pct[$g['current_grade']] ?>" style="width:0;background:<?= $colors[$g['current_grade']] ?>"></div>
                    </div>
                </div>
                <?php endwhile; ?>
                <?php endif; ?>
            </div>

            <!-- UPCOMING REMINDERS -->
            <div class="card">
                <div class="card-title" style="justify-content:space-between">
                    <span>🔔 Reminders</span>
                    <a href="<?= BASE_PATH ?>/reminders.php" class="btn btn-outline btn-sm">View All</a>
                </div>
                <?php if (mysqli_num_rows($rem_res) == 0): ?>
                    <p style="color:var(--text-muted);font-size:0.85rem;text-align:center;padding:0.5rem"><a href="<?= BASE_PATH ?>/reminders.php" style="color:var(--purple-light)">Add reminders →</a></p>
                <?php else: ?>
                <?php while ($r = mysqli_fetch_assoc($rem_res)): ?>
                <div style="border-bottom:1px solid var(--border);padding:0.6rem 0;last-child:border:none">
                    <div style="font-size:0.88rem;font-weight:500"><?= htmlspecialchars($r['title']) ?></div>
                    <div style="font-size:0.78rem;color:var(--warning);margin-top:0.2rem">📅 <?= date('M d, g:i A', strtotime($r['remind_date'])) ?></div>
                </div>
                <?php endwhile; ?>
                <?php endif; ?>
            </div>

            <!-- ACHIEVEMENTS -->
            <div class="card">
                <div class="card-title">🏅 Achievements</div>
                <?php if (mysqli_num_rows($badges_res) == 0): ?>
                    <p style="color:var(--text-muted);font-size:0.82rem;text-align:center;padding:0.5rem">Complete study sessions to earn badges!</p>
                <?php else: ?>
                <div class="achievements-grid">
                <?php while ($b = mysqli_fetch_assoc($badges_res)): ?>
                    <div class="achievement-item"><?= $b['badge_icon'] ?> <?= htmlspecialchars($b['badge_name']) ?></div>
                <?php endwhile; ?>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
<?php if (!empty($subjectHrs)): ?>
new Chart(document.getElementById('subjectChart'), {
    type: 'doughnut',
    data: {
        labels: <?= json_encode($labels) ?>,
        datasets: [{ data: <?= json_encode($data) ?>, backgroundColor: ['#6c3fc5','#00d4a0','#b44eff','#f59e0b','#60a5fa','#f97316'], borderWidth: 0, hoverOffset: 6 }]
    },
    options: { plugins: { legend: { position: 'bottom' } }, cutout: '60%' }
});
<?php endif; ?>

new Chart(document.getElementById('monthChart'), {
    type: 'line',
    data: {
        labels: <?= json_encode($months) ?>,
        datasets: [{
            label: 'Study Hours',
            data: <?= json_encode($month_data) ?>,
            borderColor: '#6c3fc5',
            backgroundColor: 'rgba(108,63,197,0.1)',
            borderWidth: 2.5,
            fill: true,
            tension: 0.4,
            pointBackgroundColor: '#b44eff',
            pointRadius: 5
        }]
    },
    options: { plugins: { legend: { display: false } }, scales: { y: { beginAtZero: true } } }
});
</script>

<?php include 'includes/footer.php'; ?>
