<?php
session_start();
include 'includes/db.php';
include 'includes/functions.php';
include 'includes/ai_feedback.php';
requireLogin();

$uid = $_SESSION['user_id'];

// Force refresh if requested
if (isset($_GET['refresh'])) {
    unset($_SESSION['ai_report']);
}

$report  = getCachedReport($conn, $uid);
$data    = $report['data'];
$rules   = $report['rules'];
$aiText  = $report['ai_insight'];
$user    = $data['user'];

$statusColors = [
    'excellent'         => ['color'=>'#00d4a0', 'bg'=>'rgba(0,212,160,0.1)', 'border'=>'rgba(0,212,160,0.3)', 'label'=>'Excellent 🌟'],
    'good'              => ['color'=>'#6c3fc5', 'bg'=>'rgba(108,63,197,0.1)', 'border'=>'rgba(108,63,197,0.3)', 'label'=>'Good 👍'],
    'needs_improvement' => ['color'=>'#f59e0b', 'bg'=>'rgba(245,158,11,0.1)', 'border'=>'rgba(245,158,11,0.3)', 'label'=>'Needs Improvement ⚠️'],
    'critical'          => ['color'=>'#ff4d6d', 'bg'=>'rgba(255,77,109,0.1)', 'border'=>'rgba(255,77,109,0.3)', 'label'=>'Critical 🚨'],
];
$sc = $statusColors[$rules['overall_status']];

$trendIcons = ['improving'=>'📈','declining'=>'📉','stable'=>'➡️','insufficient_data'=>'❓'];
$priorityColors = ['HIGH'=>'var(--danger)','MEDIUM'=>'var(--warning)','LOW'=>'var(--green)'];

$pageTitle = 'AI Feedback';
include 'includes/header.php';
?>

<style>
.ai-section { background:var(--bg-card); border:1px solid var(--border); border-radius:var(--radius); padding:1.75rem; margin-bottom:1.5rem; }
.ai-section-title { font-size:1.05rem; font-weight:700; margin-bottom:1.25rem; display:flex; align-items:center; gap:0.6rem; }
.health-ring { position:relative; width:130px; height:130px; flex-shrink:0; }
.health-ring svg { transform:rotate(-90deg); }
.health-ring-val { position:absolute; inset:0; display:flex; flex-direction:column; align-items:center; justify-content:center; }
.health-ring-val .num { font-size:2rem; font-weight:900; line-height:1; }
.health-ring-val .lbl { font-size:0.68rem; color:var(--text-muted); margin-top:2px; }
.subject-card { background:var(--bg-secondary); border:1px solid var(--border); border-radius:10px; padding:1.1rem; }
.pred-badge { display:inline-flex; align-items:center; gap:0.3rem; padding:0.3rem 0.65rem; border-radius:99px; font-size:0.78rem; font-weight:700; }
.tip-item { display:flex; gap:0.75rem; padding:0.65rem 0; border-bottom:1px solid rgba(42,42,69,0.4); align-items:flex-start; }
.tip-item:last-child { border:none; }
.tip-dot { width:7px; height:7px; border-radius:50%; background:var(--purple-light); flex-shrink:0; margin-top:6px; }
.rec-row { display:flex; align-items:center; gap:1rem; padding:0.8rem 0; border-bottom:1px solid rgba(42,42,69,0.4); }
.rec-row:last-child { border:none; }
.ai-insight-box { background:linear-gradient(135deg,rgba(108,63,197,0.08),rgba(0,212,160,0.04)); border:1px solid rgba(108,63,197,0.25); border-radius:var(--radius); padding:1.75rem; white-space:pre-wrap; font-size:0.9rem; line-height:1.8; color:var(--text-secondary); }
.ai-insight-box strong, .ai-insight-box b { color:var(--text-primary); }
.trend-pill { display:inline-flex; align-items:center; gap:0.3rem; font-size:0.78rem; padding:0.2rem 0.55rem; border-radius:99px; }
.trend-improving { background:rgba(0,212,160,0.12); color:var(--green); }
.trend-declining { background:rgba(255,77,109,0.12); color:var(--danger); }
.trend-stable    { background:rgba(108,63,197,0.12); color:var(--purple-light); }
.overview-hero { display:flex; gap:2rem; align-items:center; flex-wrap:wrap; }
.overview-info { flex:1; min-width:200px; }
.refresh-btn { font-size:0.8rem; opacity:0.7; }
.refresh-btn:hover { opacity:1; }
.grade-pill { width:38px; height:38px; border-radius:50%; display:flex; align-items:center; justify-content:center; font-weight:900; font-size:1rem; flex-shrink:0; }
</style>

<div class="container">
    <div class="page-header" style="display:flex;justify-content:space-between;align-items:flex-end;flex-wrap:wrap;gap:1rem">
        <div>
            <h1><span class="emoji">🤖</span> AI Study Feedback</h1>
            <p>Personalized analysis of your performance & smart recommendations.</p>
        </div>
        <a href="?refresh=1" class="btn btn-outline btn-sm refresh-btn">🔄 Refresh Analysis</a>
    </div>

    <!-- ===== OVERVIEW HERO ===== -->
    <div class="ai-section" style="border-color:<?= $sc['border'] ?>;background:<?= $sc['bg'] ?>">
        <div class="overview-hero">
            <!-- Health Ring -->
            <div class="health-ring">
                <?php
                $score = $rules['score'];
                $r2 = 54; $circ = 2 * M_PI * $r2;
                $filled = ($score / 100) * $circ;
                ?>
                <svg width="130" height="130" viewBox="0 0 130 130">
                    <circle cx="65" cy="65" r="<?=$r2?>" fill="none" stroke="rgba(255,255,255,0.05)" stroke-width="10"/>
                    <circle cx="65" cy="65" r="<?=$r2?>" fill="none"
                        stroke="<?=$sc['color']?>" stroke-width="10"
                        stroke-dasharray="<?=$filled?> <?=$circ?>"
                        stroke-linecap="round"/>
                </svg>
                <div class="health-ring-val">
                    <span class="num" style="color:<?=$sc['color']?>"><?=$score?></span>
                    <span class="lbl">Study Score</span>
                </div>
            </div>

            <div class="overview-info">
                <div style="font-size:1.5rem;font-weight:800;color:<?=$sc['color']?>;margin-bottom:0.4rem">
                    <?= $sc['label'] ?>
                </div>
                <div style="font-size:0.9rem;color:var(--text-secondary);line-height:1.6;margin-bottom:1rem">
                    <?= htmlspecialchars($rules['motivation']) ?>
                </div>
                <div style="display:flex;flex-wrap:wrap;gap:0.75rem">
                    <div style="background:var(--bg-card);border:1px solid var(--border);border-radius:8px;padding:0.5rem 0.9rem;text-align:center">
                        <div style="font-size:1.3rem;font-weight:800;color:var(--green)"><?= $data['weekH'] ?>h</div>
                        <div style="font-size:0.7rem;color:var(--text-muted)">This Week</div>
                    </div>
                    <div style="background:var(--bg-card);border:1px solid var(--border);border-radius:8px;padding:0.5rem 0.9rem;text-align:center">
                        <div style="font-size:1.3rem;font-weight:800;color:var(--purple-light)"><?= round($data['avgScore'],1) ?>%</div>
                        <div style="font-size:0.7rem;color:var(--text-muted)">Avg Score</div>
                    </div>
                    <div style="background:var(--bg-card);border:1px solid var(--border);border-radius:8px;padding:0.5rem 0.9rem;text-align:center">
                        <div style="font-size:1.3rem;font-weight:800;color:var(--accent)"><?= $data['streak'] ?>🔥</div>
                        <div style="font-size:0.7rem;color:var(--text-muted)">Day Streak</div>
                    </div>
                    <div style="background:var(--bg-card);border:1px solid var(--border);border-radius:8px;padding:0.5rem 0.9rem;text-align:center">
                        <div style="font-size:1.3rem;font-weight:800;color:var(--warning)"><?= $data['studyDays'] ?>/30</div>
                        <div style="font-size:0.7rem;color:var(--text-muted)">Active Days</div>
                    </div>
                </div>
            </div>

            <!-- Overall trend -->
            <?php if ($rules['trend_analysis'] !== 'insufficient_data'): ?>
            <div style="text-align:center;flex-shrink:0">
                <div style="font-size:3rem"><?= $trendIcons[$rules['trend_analysis']] ?></div>
                <div style="font-size:0.82rem;font-weight:600;color:var(--text-secondary);margin-top:0.3rem;text-transform:capitalize">
                    <?= str_replace('_',' ',$rules['trend_analysis']) ?>
                </div>
                <div style="font-size:0.72rem;color:var(--text-muted)">Overall Trend</div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <div class="grid-2">
        <!-- ===== WEAK SUBJECTS ===== -->
        <div class="ai-section">
            <div class="ai-section-title">🚨 Subjects Needing Attention</div>
            <?php if (empty($rules['weak_subjects'])): ?>
                <div class="empty-state" style="padding:1.5rem"><div class="empty-icon">🎉</div><h3>No weak subjects!</h3><p>All subjects are above 50%. Keep it up!</p></div>
            <?php else: ?>
            <?php foreach ($rules['weak_subjects'] as $ws):
                $gc = ['A'=>'#00d4a0','B'=>'#6c3fc5','C'=>'#f59e0b','S'=>'#f97316','F'=>'#ff4d6d'];
                $gColor = $gc[$ws['grade']] ?? '#ff4d6d';
            ?>
            <div class="subject-card" style="margin-bottom:0.75rem;border-left:3px solid <?=$gColor?>">
                <div style="display:flex;align-items:center;gap:0.75rem;margin-bottom:0.5rem">
                    <div class="grade-pill" style="background:<?=$gColor?>22;color:<?=$gColor?>"><?=$ws['grade']?></div>
                    <div>
                        <div style="font-weight:700;font-size:0.95rem"><?=htmlspecialchars($ws['subject'])?></div>
                        <div style="font-size:0.78rem;color:var(--text-muted)">Average: <span style="color:<?=$gColor?>;font-weight:600"><?=$ws['avg']?>%</span></div>
                    </div>
                </div>
                <div class="progress-bar"><div style="width:<?=$ws['avg']?>%;height:100%;border-radius:99px;background:<?=$gColor?>"></div></div>
                <!-- Tips for this subject -->
                <?php if (isset($rules['tips'][$ws['subject']])): ?>
                <div style="margin-top:0.75rem">
                    <?php foreach ($rules['tips'][$ws['subject']] as $tip): ?>
                    <div class="tip-item"><div class="tip-dot"></div><div style="font-size:0.82rem;color:var(--text-secondary)"><?=htmlspecialchars($tip)?></div></div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
            <?php endforeach; ?>
            <?php endif; ?>
        </div>

        <!-- ===== STRONG SUBJECTS ===== -->
        <div class="ai-section">
            <div class="ai-section-title">⭐ Strong Subjects</div>
            <?php if (empty($rules['strong_subjects'])): ?>
                <div class="empty-state" style="padding:1.5rem"><div class="empty-icon">📚</div><h3>Keep working!</h3><p>Score 70%+ in past papers to appear here.</p></div>
            <?php else: ?>
            <?php foreach ($rules['strong_subjects'] as $ss):
                $gColor = $ss['grade'] === 'A' ? '#00d4a0' : '#6c3fc5';
            ?>
            <div class="subject-card" style="margin-bottom:0.75rem;border-left:3px solid <?=$gColor?>">
                <div style="display:flex;align-items:center;gap:0.75rem">
                    <div class="grade-pill" style="background:<?=$gColor?>22;color:<?=$gColor?>"><?=$ss['grade']?></div>
                    <div style="flex:1">
                        <div style="font-weight:700"><?=htmlspecialchars($ss['subject'])?></div>
                        <div style="font-size:0.78rem;color:var(--text-muted)">Average: <span style="color:<?=$gColor?>;font-weight:600"><?=$ss['avg']?>%</span></div>
                    </div>
                    <div style="font-size:1.5rem">💪</div>
                </div>
                <div class="progress-bar" style="margin-top:0.5rem"><div style="width:<?=$ss['avg']?>%;height:100%;border-radius:99px;background:linear-gradient(90deg,<?=$gColor?>aa,<?=$gColor?>)"></div></div>
            </div>
            <?php endforeach; ?>
            <?php endif; ?>

            <!-- Neglected subjects -->
            <?php if (!empty($rules['neglected_subjects'])): ?>
            <div style="margin-top:1.25rem;padding:1rem;background:rgba(245,158,11,0.08);border:1px solid rgba(245,158,11,0.25);border-radius:10px">
                <div style="font-size:0.85rem;font-weight:700;color:var(--warning);margin-bottom:0.5rem">⚠️ Neglected (no past paper data)</div>
                <?php foreach ($rules['neglected_subjects'] as $ns): ?>
                <div style="font-size:0.83rem;color:var(--text-secondary);padding:0.25rem 0">📖 <?=htmlspecialchars($ns)?></div>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- ===== GRADE PREDICTIONS ===== -->
    <?php if (!empty($rules['grade_predictions'])): ?>
    <div class="ai-section">
        <div class="ai-section-title">🔮 Grade Predictions</div>
        <p style="font-size:0.82rem;color:var(--text-muted);margin-bottom:1.25rem">Based on your past paper averages and performance trend. These are estimates — your actual results depend on continued effort.</p>
        <div style="display:grid;grid-template-columns:repeat(auto-fill,minmax(220px,1fr));gap:1rem">
        <?php
        $gc2 = ['A'=>['#00d4a0','rgba(0,212,160,0.1)'],'B'=>['#6c3fc5','rgba(108,63,197,0.1)'],'C'=>['#f59e0b','rgba(245,158,11,0.1)'],'S'=>['#f97316','rgba(249,115,22,0.1)'],'F'=>['#ff4d6d','rgba(255,77,109,0.1)']];
        foreach ($rules['grade_predictions'] as $subj => $pred):
            [$gclr, $gbg] = $gc2[$pred['predicted_grade']] ?? ['#aaa','rgba(170,170,170,0.1)'];
            $trendClass = 'trend-' . $pred['trend'];
        ?>
        <div style="background:<?=$gbg?>;border:1px solid <?=$gclr?>33;border-radius:10px;padding:1rem">
            <div style="font-weight:700;font-size:0.9rem;margin-bottom:0.6rem"><?=htmlspecialchars($subj)?></div>
            <div style="display:flex;align-items:center;gap:0.6rem;margin-bottom:0.5rem">
                <div style="font-size:2rem;font-weight:900;color:<?=$gclr?>;line-height:1"><?=$pred['predicted_grade']?></div>
                <div>
                    <div style="font-size:0.72rem;color:var(--text-muted)">Predicted</div>
                    <div style="font-size:0.82rem;color:<?=$gclr?>;font-weight:600"><?=$pred['predicted_pct']?>%</div>
                </div>
            </div>
            <div style="display:flex;align-items:center;gap:0.5rem">
                <span style="font-size:0.72rem;color:var(--text-muted)">Current avg: <?=$pred['current_avg']?>%</span>
                <span class="trend-pill <?=$trendClass?>"><?=$trendIcons[$pred['trend']]?> <?=ucfirst($pred['trend'])?></span>
            </div>
        </div>
        <?php endforeach; ?>
        </div>
    </div>
    <?php endif; ?>

    <!-- ===== STUDY RECOMMENDATIONS ===== -->
    <?php if (!empty($rules['study_recommendations'])): ?>
    <div class="ai-section">
        <div class="ai-section-title">📅 Study Hour Recommendations</div>
        <p style="font-size:0.82rem;color:var(--text-muted);margin-bottom:1.25rem">Recommended daily study hours per subject based on your current performance gaps.</p>
        <?php foreach ($rules['study_recommendations'] as $rec): ?>
        <div class="rec-row">
            <div style="width:8px;height:8px;border-radius:50%;background:<?=$priorityColors[$rec['priority']]?>;flex-shrink:0"></div>
            <div style="flex:1">
                <div style="font-weight:600;font-size:0.92rem"><?=htmlspecialchars($rec['subject'])?></div>
                <div style="font-size:0.78rem;color:var(--text-muted)"><?=htmlspecialchars($rec['reason'])?></div>
            </div>
            <div style="text-align:right;flex-shrink:0">
                <div style="font-size:0.72rem;color:var(--text-muted)">Current</div>
                <div style="font-weight:700;color:var(--text-secondary)"><?=$rec['current_hours']?>h total</div>
            </div>
            <div style="font-size:1.2rem;color:var(--text-muted)">→</div>
            <div style="text-align:center;background:var(--bg-secondary);border-radius:8px;padding:0.5rem 0.75rem;flex-shrink:0">
                <div style="font-size:1.1rem;font-weight:800;color:<?=$priorityColors[$rec['priority']]?>"><?=$rec['recommend_hours']?>h</div>
                <div style="font-size:0.68rem;color:var(--text-muted)">per day</div>
            </div>
            <span style="font-size:0.72rem;font-weight:700;padding:0.25rem 0.6rem;border-radius:99px;background:<?=$priorityColors[$rec['priority']]?>22;color:<?=$priorityColors[$rec['priority']]?>"><?=$rec['priority']?></span>
        </div>
        <?php endforeach; ?>
    </div>
    <?php endif; ?>

    <!-- ===== CLAUDE AI DEEP ANALYSIS ===== -->
    <?php if (!empty($aiText)): ?>
    <div class="ai-section" style="border-color:rgba(108,63,197,0.35)">
        <div class="ai-section-title">
            <span style="background:linear-gradient(135deg,#6c3fc5,#b44eff);padding:0.3rem 0.7rem;border-radius:8px;font-size:0.82rem">✨ Claude AI</span>
            Deep Personalized Analysis
        </div>
        <div class="ai-insight-box"><?= nl2br(htmlspecialchars($aiText)) ?></div>
    </div>
    <?php elseif (defined('CLAUDE_API_KEY') && CLAUDE_API_KEY === 'your_claude_api_key_here'): ?>
    <div class="ai-section" style="border-color:rgba(108,63,197,0.25)">
        <div class="ai-section-title">✨ Claude AI Deep Analysis</div>
        <div style="background:rgba(108,63,197,0.08);border:1px dashed rgba(108,63,197,0.3);border-radius:10px;padding:1.5rem;text-align:center">
            <div style="font-size:2rem;margin-bottom:0.75rem">🔑</div>
            <div style="font-weight:600;margin-bottom:0.5rem">Add Claude API Key for AI-Powered Analysis</div>
            <div style="font-size:0.85rem;color:var(--text-muted);margin-bottom:1rem">
                Open <code style="background:var(--bg-secondary);padding:0.2rem 0.5rem;border-radius:4px">includes/ai_feedback.php</code>
                and replace <code style="background:var(--bg-secondary);padding:0.2rem 0.5rem;border-radius:4px">your_claude_api_key_here</code>
                with your key from <a href="https://console.anthropic.com" target="_blank" style="color:var(--purple-light)">console.anthropic.com</a>
            </div>
            <div style="font-size:0.78rem;color:var(--text-muted)">The rules-based analysis above works without an API key.</div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Generated time -->
    <div style="text-align:center;padding:0.5rem;color:var(--text-muted);font-size:0.75rem">
        Analysis generated: <?= $report['generated'] ?> &nbsp;|&nbsp;
        <a href="?refresh=1" style="color:var(--purple-light)">Refresh</a>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
