<?php
session_start();
include '../includes/db.php';
include '../includes/functions.php';
requireAdmin();

$total_users = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as c FROM users"))['c'];
$total_sessions = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as c FROM study_sessions"))['c'];
$total_papers = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as c FROM past_papers"))['c'];
$new_today = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) as c FROM users WHERE DATE(created_at)=CURDATE()"))['c'];

$users_res = mysqli_query($conn, "SELECT u.*, 
    (SELECT COUNT(*) FROM study_sessions WHERE user_id=u.id) as session_count,
    (SELECT COALESCE(SUM(hours),0) FROM study_sessions WHERE user_id=u.id) as total_hours
    FROM users u ORDER BY u.created_at DESC LIMIT 50");

$pageTitle = 'Admin';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin | StudyTrack LK</title>
    <link rel="stylesheet" href="<?= BASE_PATH ?>/assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
</head>
<body>
<nav class="navbar">
    <div class="nav-brand"><span class="nav-logo">📚</span><span class="nav-title">StudyTrack <span class="accent">LK</span> <span style="color:var(--warning);font-size:0.75rem">ADMIN</span></span></div>
    <ul class="nav-links">
        <li><a href="<?= BASE_PATH ?>/dashboard.php">← Back to Site</a></li>
        <li><a href="<?= BASE_PATH ?>/logout.php" class="btn-logout" style="color:var(--danger)">Logout</a></li>
    </ul>
</nav>

<div class="container">
    <div class="page-header">
        <h1>⚙️ Admin Dashboard</h1>
        <p>Platform overview and user management.</p>
    </div>

    <div class="stats-grid">
        <div class="stat-card purple"><div class="stat-icon">👥</div><div class="stat-label">Total Users</div><div class="stat-value"><?= $total_users ?></div></div>
        <div class="stat-card green"><div class="stat-icon">🆕</div><div class="stat-label">New Today</div><div class="stat-value"><?= $new_today ?></div></div>
        <div class="stat-card blue"><div class="stat-icon">⏱️</div><div class="stat-label">Study Sessions</div><div class="stat-value"><?= $total_sessions ?></div></div>
        <div class="stat-card orange"><div class="stat-icon">📝</div><div class="stat-label">Papers Logged</div><div class="stat-value"><?= $total_papers ?></div></div>
    </div>

    <div class="card">
        <div class="card-title">👥 All Users</div>
        <div class="table-wrap">
            <table>
                <thead><tr><th>Name</th><th>Email</th><th>Stream</th><th>Exam Year</th><th>Sessions</th><th>Total Hours</th><th>Joined</th><th>Role</th></tr></thead>
                <tbody>
                <?php while ($u = mysqli_fetch_assoc($users_res)): ?>
                <tr>
                    <td style="font-weight:600"><?= htmlspecialchars($u['name']) ?></td>
                    <td style="color:var(--text-secondary)"><?= htmlspecialchars($u['email']) ?></td>
                    <td><span class="badge badge-purple"><?= $u['stream'] ?></span></td>
                    <td><?= $u['exam_year'] ?></td>
                    <td><?= $u['session_count'] ?></td>
                    <td style="color:var(--green)"><?= round($u['total_hours'],1) ?>h</td>
                    <td style="color:var(--text-muted);font-size:0.8rem"><?= date('M d, Y', strtotime($u['created_at'])) ?></td>
                    <td><?= $u['is_admin'] ? '<span class="badge badge-green">Admin</span>' : '<span class="badge">Student</span>' ?></td>
                </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<footer class="footer"><p>📚 StudyTrack LK Admin Panel &copy; <?= date('Y') ?></p></footer>
<script src="<?= BASE_PATH ?>/assets/js/main.js"></script>
</body>
</html>
